<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Family extends Model 
{

    protected $table = 'families';
    public $timestamps = true;
    protected $fillable = array('user_id', 'family_name', 'commercial_name', 'lat', 'lng', 'address', 'id_number', 'id_image', 'bank_name', 'bank_number', 'iban_number', 'tax_number', 'health_image', 'marketer_code', 'online', 'delivery');

    public function categories()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City', 'city_id');
    }

    public function user()
    {
        return $this->belongsToMany('User', 'user_id');
    }

}